/*
 *  This file is a part of libacars
 *
 *  Copyright (c) 2018-2021 Tomasz Lemiech <szpajder@gmail.com>
 */

#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>

/*****************************************************************/
/*                                                               */
/* CRC LOOKUP TABLE                                              */
/* ================                                              */
/* The following CRC lookup table was generated automagically    */
/* by the Rocksoft^tm Model CRC Algorithm Table Generation       */
/* Program V1.0 using the following model parameters:            */
/*                                                               */
/*    Width   : 2 bytes.                                         */
/*    Poly    : 0x1021                                           */
/*    Reverse : FALSE.                                           */
/*                                                               */
/* For more information on the Rocksoft^tm Model CRC Algorithm,  */
/* see the document titled "A Painless Guide to CRC Error        */
/* Detection Algorithms" by Ross Williams                        */
/* (ross@guest.adelaide.edu.au.). This document is likely to be  */
/* in the FTP archive "ftp.adelaide.edu.au/pub/rocksoft".        */
/*                                                               */
/*****************************************************************/
uint16_t la_crc16_arinc(uint8_t const *data, uint32_t len, uint16_t crc_init) {
	static uint16_t const crctable[256] =
	{
		0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
		0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
		0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
		0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
		0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
		0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
		0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
		0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
		0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
		0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
		0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
		0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
		0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
		0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
		0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
		0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
		0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
		0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
		0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
		0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
		0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
		0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
		0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
		0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
		0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
		0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
		0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
		0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
		0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
		0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
		0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
		0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
	};
	uint16_t crc = crc_init;
	while (len-- > 0) {
		crc = (crc << 8) ^ crctable[((crc >> 8) ^ *data++) & 0xff];
	}
	return crc;
}

uint16_t la_crc16_ccitt(uint8_t const *data, uint32_t len, uint16_t crc_init) {
	/* CRC-16-CCITT, poly: 0x1021 */
	static uint16_t const crctable[256] =
	{
		0x0000, 0x1189, 0x2312, 0x329B, 0x4624, 0x57AD, 0x6536, 0x74BF,
		0x8C48, 0x9DC1, 0xAF5A, 0xBED3, 0xCA6C, 0xDBE5, 0xE97E, 0xF8F7,
		0x1081, 0x0108, 0x3393, 0x221A, 0x56A5, 0x472C, 0x75B7, 0x643E,
		0x9CC9, 0x8D40, 0xBFDB, 0xAE52, 0xDAED, 0xCB64, 0xF9FF, 0xE876,
		0x2102, 0x308B, 0x0210, 0x1399, 0x6726, 0x76AF, 0x4434, 0x55BD,
		0xAD4A, 0xBCC3, 0x8E58, 0x9FD1, 0xEB6E, 0xFAE7, 0xC87C, 0xD9F5,
		0x3183, 0x200A, 0x1291, 0x0318, 0x77A7, 0x662E, 0x54B5, 0x453C,
		0xBDCB, 0xAC42, 0x9ED9, 0x8F50, 0xFBEF, 0xEA66, 0xD8FD, 0xC974,
		0x4204, 0x538D, 0x6116, 0x709F, 0x0420, 0x15A9, 0x2732, 0x36BB,
		0xCE4C, 0xDFC5, 0xED5E, 0xFCD7, 0x8868, 0x99E1, 0xAB7A, 0xBAF3,
		0x5285, 0x430C, 0x7197, 0x601E, 0x14A1, 0x0528, 0x37B3, 0x263A,
		0xDECD, 0xCF44, 0xFDDF, 0xEC56, 0x98E9, 0x8960, 0xBBFB, 0xAA72,
		0x6306, 0x728F, 0x4014, 0x519D, 0x2522, 0x34AB, 0x0630, 0x17B9,
		0xEF4E, 0xFEC7, 0xCC5C, 0xDDD5, 0xA96A, 0xB8E3, 0x8A78, 0x9BF1,
		0x7387, 0x620E, 0x5095, 0x411C, 0x35A3, 0x242A, 0x16B1, 0x0738,
		0xFFCF, 0xEE46, 0xDCDD, 0xCD54, 0xB9EB, 0xA862, 0x9AF9, 0x8B70,
		0x8408, 0x9581, 0xA71A, 0xB693, 0xC22C, 0xD3A5, 0xE13E, 0xF0B7,
		0x0840, 0x19C9, 0x2B52, 0x3ADB, 0x4E64, 0x5FED, 0x6D76, 0x7CFF,
		0x9489, 0x8500, 0xB79B, 0xA612, 0xD2AD, 0xC324, 0xF1BF, 0xE036,
		0x18C1, 0x0948, 0x3BD3, 0x2A5A, 0x5EE5, 0x4F6C, 0x7DF7, 0x6C7E,
		0xA50A, 0xB483, 0x8618, 0x9791, 0xE32E, 0xF2A7, 0xC03C, 0xD1B5,
		0x2942, 0x38CB, 0x0A50, 0x1BD9, 0x6F66, 0x7EEF, 0x4C74, 0x5DFD,
		0xB58B, 0xA402, 0x9699, 0x8710, 0xF3AF, 0xE226, 0xD0BD, 0xC134,
		0x39C3, 0x284A, 0x1AD1, 0x0B58, 0x7FE7, 0x6E6E, 0x5CF5, 0x4D7C,
		0xC60C, 0xD785, 0xE51E, 0xF497, 0x8028, 0x91A1, 0xA33A, 0xB2B3,
		0x4A44, 0x5BCD, 0x6956, 0x78DF, 0x0C60, 0x1DE9, 0x2F72, 0x3EFB,
		0xD68D, 0xC704, 0xF59F, 0xE416, 0x90A9, 0x8120, 0xB3BB, 0xA232,
		0x5AC5, 0x4B4C, 0x79D7, 0x685E, 0x1CE1, 0x0D68, 0x3FF3, 0x2E7A,
		0xE70E, 0xF687, 0xC41C, 0xD595, 0xA12A, 0xB0A3, 0x8238, 0x93B1,
		0x6B46, 0x7ACF, 0x4854, 0x59DD, 0x2D62, 0x3CEB, 0x0E70, 0x1FF9,
		0xF78F, 0xE606, 0xD49D, 0xC514, 0xB1AB, 0xA022, 0x92B9, 0x8330,
		0x7BC7, 0x6A4E, 0x58D5, 0x495C, 0x3DE3, 0x2C6A, 0x1EF1, 0x0F78
	};
	uint16_t crc = crc_init;
	while (len-- > 0) {
		crc = (crc >> 8) ^ crctable[(crc ^ *data++) & 0xff];
	}
	return crc;
}

uint32_t la_crc32_arinc665(uint8_t const *data, uint32_t len, uint32_t crc_init) {
	// Width   : 4 bytes
	// Poly    : 0x04C11DB7L
	// Reverse : FALSE
	static uint32_t const crctable[256] =
	{
		0x00000000L, 0x04C11DB7L, 0x09823B6EL, 0x0D4326D9L,
		0x130476DCL, 0x17C56B6BL, 0x1A864DB2L, 0x1E475005L,
		0x2608EDB8L, 0x22C9F00FL, 0x2F8AD6D6L, 0x2B4BCB61L,
		0x350C9B64L, 0x31CD86D3L, 0x3C8EA00AL, 0x384FBDBDL,
		0x4C11DB70L, 0x48D0C6C7L, 0x4593E01EL, 0x4152FDA9L,
		0x5F15ADACL, 0x5BD4B01BL, 0x569796C2L, 0x52568B75L,
		0x6A1936C8L, 0x6ED82B7FL, 0x639B0DA6L, 0x675A1011L,
		0x791D4014L, 0x7DDC5DA3L, 0x709F7B7AL, 0x745E66CDL,
		0x9823B6E0L, 0x9CE2AB57L, 0x91A18D8EL, 0x95609039L,
		0x8B27C03CL, 0x8FE6DD8BL, 0x82A5FB52L, 0x8664E6E5L,
		0xBE2B5B58L, 0xBAEA46EFL, 0xB7A96036L, 0xB3687D81L,
		0xAD2F2D84L, 0xA9EE3033L, 0xA4AD16EAL, 0xA06C0B5DL,
		0xD4326D90L, 0xD0F37027L, 0xDDB056FEL, 0xD9714B49L,
		0xC7361B4CL, 0xC3F706FBL, 0xCEB42022L, 0xCA753D95L,
		0xF23A8028L, 0xF6FB9D9FL, 0xFBB8BB46L, 0xFF79A6F1L,
		0xE13EF6F4L, 0xE5FFEB43L, 0xE8BCCD9AL, 0xEC7DD02DL,
		0x34867077L, 0x30476DC0L, 0x3D044B19L, 0x39C556AEL,
		0x278206ABL, 0x23431B1CL, 0x2E003DC5L, 0x2AC12072L,
		0x128E9DCFL, 0x164F8078L, 0x1B0CA6A1L, 0x1FCDBB16L,
		0x018AEB13L, 0x054BF6A4L, 0x0808D07DL, 0x0CC9CDCAL,
		0x7897AB07L, 0x7C56B6B0L, 0x71159069L, 0x75D48DDEL,
		0x6B93DDDBL, 0x6F52C06CL, 0x6211E6B5L, 0x66D0FB02L,
		0x5E9F46BFL, 0x5A5E5B08L, 0x571D7DD1L, 0x53DC6066L,
		0x4D9B3063L, 0x495A2DD4L, 0x44190B0DL, 0x40D816BAL,
		0xACA5C697L, 0xA864DB20L, 0xA527FDF9L, 0xA1E6E04EL,
		0xBFA1B04BL, 0xBB60ADFCL, 0xB6238B25L, 0xB2E29692L,
		0x8AAD2B2FL, 0x8E6C3698L, 0x832F1041L, 0x87EE0DF6L,
		0x99A95DF3L, 0x9D684044L, 0x902B669DL, 0x94EA7B2AL,
		0xE0B41DE7L, 0xE4750050L, 0xE9362689L, 0xEDF73B3EL,
		0xF3B06B3BL, 0xF771768CL, 0xFA325055L, 0xFEF34DE2L,
		0xC6BCF05FL, 0xC27DEDE8L, 0xCF3ECB31L, 0xCBFFD686L,
		0xD5B88683L, 0xD1799B34L, 0xDC3ABDEDL, 0xD8FBA05AL,
		0x690CE0EEL, 0x6DCDFD59L, 0x608EDB80L, 0x644FC637L,
		0x7A089632L, 0x7EC98B85L, 0x738AAD5CL, 0x774BB0EBL,
		0x4F040D56L, 0x4BC510E1L, 0x46863638L, 0x42472B8FL,
		0x5C007B8AL, 0x58C1663DL, 0x558240E4L, 0x51435D53L,
		0x251D3B9EL, 0x21DC2629L, 0x2C9F00F0L, 0x285E1D47L,
		0x36194D42L, 0x32D850F5L, 0x3F9B762CL, 0x3B5A6B9BL,
		0x0315D626L, 0x07D4CB91L, 0x0A97ED48L, 0x0E56F0FFL,
		0x1011A0FAL, 0x14D0BD4DL, 0x19939B94L, 0x1D528623L,
		0xF12F560EL, 0xF5EE4BB9L, 0xF8AD6D60L, 0xFC6C70D7L,
		0xE22B20D2L, 0xE6EA3D65L, 0xEBA91BBCL, 0xEF68060BL,
		0xD727BBB6L, 0xD3E6A601L, 0xDEA580D8L, 0xDA649D6FL,
		0xC423CD6AL, 0xC0E2D0DDL, 0xCDA1F604L, 0xC960EBB3L,
		0xBD3E8D7EL, 0xB9FF90C9L, 0xB4BCB610L, 0xB07DABA7L,
		0xAE3AFBA2L, 0xAAFBE615L, 0xA7B8C0CCL, 0xA379DD7BL,
		0x9B3660C6L, 0x9FF77D71L, 0x92B45BA8L, 0x9675461FL,
		0x8832161AL, 0x8CF30BADL, 0x81B02D74L, 0x857130C3L,
		0x5D8A9099L, 0x594B8D2EL, 0x5408ABF7L, 0x50C9B640L,
		0x4E8EE645L, 0x4A4FFBF2L, 0x470CDD2BL, 0x43CDC09CL,
		0x7B827D21L, 0x7F436096L, 0x7200464FL, 0x76C15BF8L,
		0x68860BFDL, 0x6C47164AL, 0x61043093L, 0x65C52D24L,
		0x119B4BE9L, 0x155A565EL, 0x18197087L, 0x1CD86D30L,
		0x029F3D35L, 0x065E2082L, 0x0B1D065BL, 0x0FDC1BECL,
		0x3793A651L, 0x3352BBE6L, 0x3E119D3FL, 0x3AD08088L,
		0x2497D08DL, 0x2056CD3AL, 0x2D15EBE3L, 0x29D4F654L,
		0xC5A92679L, 0xC1683BCEL, 0xCC2B1D17L, 0xC8EA00A0L,
		0xD6AD50A5L, 0xD26C4D12L, 0xDF2F6BCBL, 0xDBEE767CL,
		0xE3A1CBC1L, 0xE760D676L, 0xEA23F0AFL, 0xEEE2ED18L,
		0xF0A5BD1DL, 0xF464A0AAL, 0xF9278673L, 0xFDE69BC4L,
		0x89B8FD09L, 0x8D79E0BEL, 0x803AC667L, 0x84FBDBD0L,
		0x9ABC8BD5L, 0x9E7D9662L, 0x933EB0BBL, 0x97FFAD0CL,
		0xAFB010B1L, 0xAB710D06L, 0xA6322BDFL, 0xA2F33668L,
		0xBCB4666DL, 0xB8757BDAL, 0xB5365D03L, 0xB1F740B4L
	};
	uint32_t crc = crc_init;
	while (len-- > 0) {
		crc = (crc << 8) ^ crctable[(crc >> 24) ^ *data++];
	}
	return crc;
}
