# ThreadsWait

This class watches for termination of multiple threads.  Basic functionality (wait until specified threads have terminated) can be accessed through the class method ThreadsWait::all_waits.  Finer control can be gained using instance methods.

## Installation

Add this line to your application's Gemfile:

```ruby
gem 'thwait'
```

And then execute:

    $ bundle

Or install it yourself as:

    $ gem install thwait

## Usage

```
  ThreadsWait.all_waits(thr1, thr2, ...) do |t|
    STDERR.puts "Thread #{t} has terminated."
  end

  th = ThreadsWait.new(thread1,...)
  th.next_wait # next one to be done
```

## Development

After checking out the repo, run `bin/setup` to install dependencies. Then, run `rake test` to run the tests. You can also run `bin/console` for an interactive prompt that will allow you to experiment.

To install this gem onto your local machine, run `bundle exec rake install`. To release a new version, update the version number in `version.rb`, and then run `bundle exec rake release`, which will create a git tag for the version, push git commits and tags, and push the `.gem` file to [rubygems.org](https://rubygems.org).

## Contributing

Bug reports and pull requests are welcome on GitHub at https://github.com/ruby/thwait.

## License

The gem is available as open source under the terms of the [2-Clause BSD License](https://opensource.org/licenses/BSD-2-Clause).
