% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycles.R
\name{simple_cycles}
\alias{simple_cycles}
\title{Finds all simple cycles in a graph.}
\usage{
simple_cycles(
  graph,
  mode = c("out", "in", "all", "total"),
  min = NULL,
  max = NULL
)
}
\arguments{
\item{graph}{The input graph.}

\item{mode}{Character constant specifying how to handle directed graphs.
\code{out} follows edge directions, \verb{in} follows edges in the reverse direction,
and \code{all} ignores edge directions. Ignored in undirected graphs.}

\item{min}{Lower limit on cycle lengths to consider. \code{NULL} means no limit.}

\item{max}{Upper limit on cycle lengths to consider. \code{NULL} means no limit.}
}
\value{
A named list, with two entries:
\item{vertices}{The list of cycles in terms of their vertices.}
\item{edges}{The list of cycles in terms of their edges.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function lists all simple cycles in a graph within a range of cycle
lengths. A cycle is called simple if it has no repeated vertices.

Multi-edges and self-loops are taken into account. Note that typical graphs
have exponentially many cycles and the presence of multi-edges exacerbates
this combinatorial explosion.
}
\examples{

g <- graph_from_literal(A -+ B -+ C -+ A -+ D -+ E +- F -+ A, E -+ E, A -+ F, simplify = FALSE)
simple_cycles(g)
simple_cycles(g, mode = "all") # ignore edge directions
simple_cycles(g, mode = "all", min = 2, max = 3) # limit cycle lengths

}
\seealso{
Graph cycles
\code{\link{feedback_arc_set}()},
\code{\link{feedback_vertex_set}()},
\code{\link{find_cycle}()},
\code{\link{girth}()},
\code{\link{has_eulerian_path}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()}
}
\concept{cycles}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Cycles.html#igraph_simple_cycles}{\code{simple_cycles()}}.}

