// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "v3_24")]
#[cfg_attr(docsrs, doc(cfg(feature = "v3_24")))]
use crate::FontChooserLevel;
use crate::{
    Actionable, Align, Bin, Buildable, Button, Container, FontChooser, PositionType, ReliefStyle,
    ResizeMode, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkFontButton")]
    pub struct FontButton(Object<ffi::GtkFontButton, ffi::GtkFontButtonClass>) @extends Button, Bin, Container, Widget, @implements Buildable, Actionable, FontChooser;

    match fn {
        type_ => || ffi::gtk_font_button_get_type(),
    }
}

impl FontButton {
    pub const NONE: Option<&'static FontButton> = None;

    #[doc(alias = "gtk_font_button_new")]
    pub fn new() -> FontButton {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_font_button_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_font_button_new_with_font")]
    #[doc(alias = "new_with_font")]
    pub fn with_font(fontname: &str) -> FontButton {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_font_button_new_with_font(
                fontname.to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`FontButton`] objects.
    ///
    /// This method returns an instance of [`FontButtonBuilder`](crate::builders::FontButtonBuilder) which can be used to create [`FontButton`] objects.
    pub fn builder() -> FontButtonBuilder {
        FontButtonBuilder::new()
    }
}

impl Default for FontButton {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`FontButton`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct FontButtonBuilder {
    builder: glib::object::ObjectBuilder<'static, FontButton>,
}

impl FontButtonBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn show_size(self, show_size: bool) -> Self {
        Self {
            builder: self.builder.property("show-size", show_size),
        }
    }

    pub fn show_style(self, show_style: bool) -> Self {
        Self {
            builder: self.builder.property("show-style", show_style),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn use_font(self, use_font: bool) -> Self {
        Self {
            builder: self.builder.property("use-font", use_font),
        }
    }

    pub fn use_size(self, use_size: bool) -> Self {
        Self {
            builder: self.builder.property("use-size", use_size),
        }
    }

    pub fn always_show_image(self, always_show_image: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("always-show-image", always_show_image),
        }
    }

    pub fn image(self, image: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("image", image.clone().upcast()),
        }
    }

    pub fn image_position(self, image_position: PositionType) -> Self {
        Self {
            builder: self.builder.property("image-position", image_position),
        }
    }

    pub fn label(self, label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("label", label.into()),
        }
    }

    pub fn relief(self, relief: ReliefStyle) -> Self {
        Self {
            builder: self.builder.property("relief", relief),
        }
    }

    pub fn use_underline(self, use_underline: bool) -> Self {
        Self {
            builder: self.builder.property("use-underline", use_underline),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn action_name(self, action_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("action-name", action_name.into()),
        }
    }

    pub fn action_target(self, action_target: &glib::Variant) -> Self {
        Self {
            builder: self
                .builder
                .property("action-target", action_target.clone()),
        }
    }

    pub fn font(self, font: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("font", font.into()),
        }
    }

    pub fn font_desc(self, font_desc: &pango::FontDescription) -> Self {
        Self {
            builder: self.builder.property("font-desc", font_desc),
        }
    }

    #[cfg(feature = "v3_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v3_24")))]
    pub fn language(self, language: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("language", language.into()),
        }
    }

    #[cfg(feature = "v3_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v3_24")))]
    pub fn level(self, level: FontChooserLevel) -> Self {
        Self {
            builder: self.builder.property("level", level),
        }
    }

    pub fn preview_text(self, preview_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("preview-text", preview_text.into()),
        }
    }

    pub fn show_preview_entry(self, show_preview_entry: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("show-preview-entry", show_preview_entry),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`FontButton`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> FontButton {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::FontButton>> Sealed for T {}
}

pub trait FontButtonExt: IsA<FontButton> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_font_button_get_show_size")]
    #[doc(alias = "get_show_size")]
    fn shows_size(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_font_button_get_show_size(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_font_button_get_show_style")]
    #[doc(alias = "get_show_style")]
    fn shows_style(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_font_button_get_show_style(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_font_button_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_font_button_get_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_font_button_get_use_font")]
    #[doc(alias = "get_use_font")]
    fn uses_font(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_font_button_get_use_font(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_font_button_get_use_size")]
    #[doc(alias = "get_use_size")]
    fn uses_size(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_font_button_get_use_size(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_font_button_set_show_size")]
    fn set_show_size(&self, show_size: bool) {
        unsafe {
            ffi::gtk_font_button_set_show_size(
                self.as_ref().to_glib_none().0,
                show_size.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_font_button_set_show_style")]
    fn set_show_style(&self, show_style: bool) {
        unsafe {
            ffi::gtk_font_button_set_show_style(
                self.as_ref().to_glib_none().0,
                show_style.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_font_button_set_title")]
    fn set_title(&self, title: &str) {
        unsafe {
            ffi::gtk_font_button_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_font_button_set_use_font")]
    fn set_use_font(&self, use_font: bool) {
        unsafe {
            ffi::gtk_font_button_set_use_font(self.as_ref().to_glib_none().0, use_font.into_glib());
        }
    }

    #[doc(alias = "gtk_font_button_set_use_size")]
    fn set_use_size(&self, use_size: bool) {
        unsafe {
            ffi::gtk_font_button_set_use_size(self.as_ref().to_glib_none().0, use_size.into_glib());
        }
    }

    #[doc(alias = "font-set")]
    fn connect_font_set<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn font_set_trampoline<P: IsA<FontButton>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkFontButton,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FontButton::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"font-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    font_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-size")]
    fn connect_show_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_size_trampoline<
            P: IsA<FontButton>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFontButton,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FontButton::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-style")]
    fn connect_show_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_style_trampoline<
            P: IsA<FontButton>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFontButton,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FontButton::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-style\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_style_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<FontButton>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkFontButton,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FontButton::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "use-font")]
    fn connect_use_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_font_trampoline<P: IsA<FontButton>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkFontButton,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FontButton::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-font\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_use_font_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "use-size")]
    fn connect_use_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_size_trampoline<P: IsA<FontButton>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkFontButton,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FontButton::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_use_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<FontButton>> FontButtonExt for O {}

impl fmt::Display for FontButton {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("FontButton")
    }
}
