/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package test.com.sun.javafx.scene.layout;

import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.util.Utils;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import test.javafx.scene.layout.MockResizable;

public class MockResizableHelper extends ParentHelper {
    private static final MockResizableHelper theInstance;
    private static MockResizableAccessor mockResizableAccessor;

    static {
        theInstance = new MockResizableHelper();
        Utils.forceInit(MockResizable.class);
    }

    private static MockResizableHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(MockResizable mockResizable) {
        setHelper(mockResizable, getInstance());
    }

    @Override
    protected Bounds computeLayoutBoundsImpl(Node node) {
        return mockResizableAccessor.doComputeLayoutBounds(node);
    }

    @Override
    protected void notifyLayoutBoundsChangedImpl(Node node) {
        mockResizableAccessor.doNotifyLayoutBoundsChanged(node);
    }
    public static void setMockResizableAccessor(final MockResizableAccessor newAccessor) {
        if (mockResizableAccessor != null) {
            throw new IllegalStateException();
        }

        mockResizableAccessor = newAccessor;
    }

    public interface MockResizableAccessor {
        Bounds doComputeLayoutBounds(Node node);
        void doNotifyLayoutBoundsChanged(Node node);
    }

}
