# Use these commands to generate the LAMMPS input script and data file
# (and other auxilliary files):

# First, generate the coordinates (the "system.xyz" file).
# (This can be a very slow process.)

# check if packmol exists before running
if ! hash packmol 2>/dev/null; then
    echo "packmol not found. This example cannot be run."
    exit 1
fi


cd packmol_files

  # You must run each packmol commend one after the other.
  #
  # NOTE: If PACKMOL gets stuck in an endless loop, then edit the corresponding
  # "inp" file (edit the "tolerance" and "distscale").  This should not happen,
  # but keep in mind that PACKMOL can be very slow.  (Step3 takes several days.)
  #
  # NOTE: You can also usually interrupt packmol after 1 hour.  The solution
  #       at that point (an .xyz file) should be good enough for use.
  #      (Of course, you should check to see that the file exists and the
  #       structure looks reasonable visually before interrupting packmol. Small
  #       holes are okay. The simulation protocol we use should close them.)

  packmol < step1_proteins.inp   # This step determines the protein's location
                                 # It takes ~40 minutes (on a 2015 intel i7)
  packmol < step2_innerlayer.inp # This step builds the inner monolayer
                                 # It takes ~10 hours
  packmol < step3_outerlayer.inp # This step builds the outer monolayer
                                 # It takes ~1-3 days
cd ..




# Create LAMMPS input files this way:
cd moltemplate_files

  # run moltemplate

  # (Note: we use the final .xyz file we created earlier.)
  moltemplate.sh -xyz ../packmol_files/step3_outerlayer.xyz system.lt

  # This will generate various files with names ending in *.in* and *.data.
  # These files are the input files directly read by LAMMPS.  Move them to
  # the parent directory (or wherever you plan to run the simulation).

  mv -f system.in* system.data ../

  # The "table_int.dat" file contains tabular data for the lipid INT-INT atom
  # 1/r^2 interaction.  We need it too. (This slows down the simulation by x2,
  # so I might look for a way to get rid of it later.)
  cp -f table_int.dat ../

  # Optional:
  # The "./output_ttree/" directory is full of temporary files generated by
  # moltemplate.  They can be useful for debugging, but are usually thrown away.
  rm -rf output_ttree/

cd ../
