/* SPDX-License-Identifier: (GPL-2.0-only OR MIT) */
/*
 * Copyright (C) 2024 Amlogic, Inc. All rights reserved
 */

#ifndef __C3_ISP_REGS_H__
#define __C3_ISP_REGS_H__

#define ISP_TOP_INPUT_SIZE				0x0000
#define ISP_TOP_INPUT_SIZE_VERT_SIZE_MASK		GENMASK(15, 0)
#define ISP_TOP_INPUT_SIZE_VERT_SIZE(x)			((x) << 0)
#define ISP_TOP_INPUT_SIZE_HORIZ_SIZE_MASK		GENMASK(31, 16)
#define ISP_TOP_INPUT_SIZE_HORIZ_SIZE(x)		((x) << 16)

#define ISP_TOP_FRM_SIZE				0x0004
#define ISP_TOP_FRM_SIZE_CORE_VERT_SIZE_MASK		GENMASK(15, 0)
#define ISP_TOP_FRM_SIZE_CORE_VERT_SIZE(x)		((x) << 0)
#define ISP_TOP_FRM_SIZE_CORE_HORIZ_SIZE_MASK		GENMASK(31, 16)
#define ISP_TOP_FRM_SIZE_CORE_HORIZ_SIZE(x)		((x) << 16)

#define ISP_TOP_HOLD_SIZE				0x0008
#define ISP_TOP_HOLD_SIZE_CORE_HORIZ_SIZE_MASK		GENMASK(31, 16)
#define ISP_TOP_HOLD_SIZE_CORE_HORIZ_SIZE(x)		((x) << 16)

#define ISP_TOP_PATH_EN					0x0010
#define ISP_TOP_PATH_EN_DISP0_EN_MASK			BIT(0)
#define ISP_TOP_PATH_EN_DISP0_EN			BIT(0)
#define ISP_TOP_PATH_EN_DISP0_DIS			(0 << 0)
#define ISP_TOP_PATH_EN_DISP1_EN_MASK			BIT(1)
#define ISP_TOP_PATH_EN_DISP1_EN			BIT(1)
#define ISP_TOP_PATH_EN_DISP1_DIS			(0 << 1)
#define ISP_TOP_PATH_EN_DISP2_EN_MASK			BIT(2)
#define ISP_TOP_PATH_EN_DISP2_EN			BIT(2)
#define ISP_TOP_PATH_EN_DISP2_DIS			(0 << 2)
#define ISP_TOP_PATH_EN_WRMIF0_EN_MASK			BIT(8)
#define ISP_TOP_PATH_EN_WRMIF0_EN			BIT(8)
#define ISP_TOP_PATH_EN_WRMIF0_DIS			(0 << 8)
#define ISP_TOP_PATH_EN_WRMIF1_EN_MASK			BIT(9)
#define ISP_TOP_PATH_EN_WRMIF1_EN			BIT(9)
#define ISP_TOP_PATH_EN_WRMIF1_DIS			(0 << 9)
#define ISP_TOP_PATH_EN_WRMIF2_EN_MASK			BIT(10)
#define ISP_TOP_PATH_EN_WRMIF2_EN			BIT(10)
#define ISP_TOP_PATH_EN_WRMIF2_DIS			(0 << 10)

#define ISP_TOP_PATH_SEL				0x0014
#define ISP_TOP_PATH_SEL_CORE_MASK			GENMASK(18, 16)
#define ISP_TOP_PATH_SEL_CORE_CORE_DIS			(0 << 16)
#define ISP_TOP_PATH_SEL_CORE_MIPI_CORE			BIT(16)

#define ISP_TOP_DISPIN_SEL				0x0018
#define ISP_TOP_DISPIN_SEL_DISP0_MASK			GENMASK(3, 0)
#define ISP_TOP_DISPIN_SEL_DISP0_CORE_OUT		(0 << 0)
#define ISP_TOP_DISPIN_SEL_DISP0_MIPI_OUT		(2 << 0)
#define ISP_TOP_DISPIN_SEL_DISP1_MASK			GENMASK(7, 4)
#define ISP_TOP_DISPIN_SEL_DISP1_CORE_OUT		(0 << 4)
#define ISP_TOP_DISPIN_SEL_DISP1_MIPI_OUT		(2 << 4)
#define ISP_TOP_DISPIN_SEL_DISP2_MASK			GENMASK(11, 8)
#define ISP_TOP_DISPIN_SEL_DISP2_CORE_OUT		(0 << 8)
#define ISP_TOP_DISPIN_SEL_DISP2_MIPI_OUT		(2 << 8)

#define ISP_TOP_IRQ_EN					0x0080
#define ISP_TOP_IRQ_EN_FRM_END_MASK			BIT(0)
#define ISP_TOP_IRQ_EN_FRM_END_EN			BIT(0)
#define ISP_TOP_IRQ_EN_FRM_END_DIS			(0 << 0)
#define ISP_TOP_IRQ_EN_FRM_RST_MASK			BIT(1)
#define ISP_TOP_IRQ_EN_FRM_RST_EN			BIT(1)
#define ISP_TOP_IRQ_EN_FRM_RST_DIS			(0 << 1)
#define ISP_TOP_IRQ_EN_3A_DMA_ERR_MASK			BIT(5)
#define ISP_TOP_IRQ_EN_3A_DMA_ERR_EN			BIT(5)
#define ISP_TOP_IRQ_EN_3A_DMA_ERR_DIS			(0 << 5)

#define ISP_TOP_IRQ_CLR					0x0084
#define ISP_TOP_RO_IRQ_STAT				0x01c4
#define ISP_TOP_RO_IRQ_STAT_FRM_END_MASK		BIT(0)
#define ISP_TOP_RO_IRQ_STAT_FRM_RST_MASK		BIT(1)
#define ISP_TOP_RO_IRQ_STAT_3A_DMA_ERR_MASK		BIT(5)

#define ISP_TOP_MODE_CTRL				0x0400
#define ISP_TOP_FEO_CTRL0				0x040c
#define ISP_TOP_FEO_CTRL0_INPUT_FMT_EN_MASK		BIT(8)
#define ISP_TOP_FEO_CTRL0_INPUT_FMT_DIS			(0 << 8)
#define ISP_TOP_FEO_CTRL0_INPUT_FMT_EN			BIT(8)

#define ISP_TOP_FEO_CTRL1_0				0x0410
#define ISP_TOP_FEO_CTRL1_0_DPC_EN_MASK			BIT(3)
#define ISP_TOP_FEO_CTRL1_0_DPC_DIS			(0 << 3)
#define ISP_TOP_FEO_CTRL1_0_DPC_EN			BIT(3)
#define ISP_TOP_FEO_CTRL1_0_OG_EN_MASK			BIT(5)
#define ISP_TOP_FEO_CTRL1_0_OG_DIS			(0 << 5)
#define ISP_TOP_FEO_CTRL1_0_OG_EN			BIT(5)

#define ISP_TOP_FED_CTRL				0x0418
#define ISP_TOP_FED_CTRL_PDPC_EN_MASK			BIT(1)
#define ISP_TOP_FED_CTRL_PDPC_DIS			(0 << 1)
#define ISP_TOP_FED_CTRL_PDPC_EN			BIT(1)
#define ISP_TOP_FED_CTRL_RAWCNR_EN_MASK			GENMASK(6, 5)
#define ISP_TOP_FED_CTRL_RAWCNR_DIS			(0 << 5)
#define ISP_TOP_FED_CTRL_RAWCNR_EN			BIT(5)
#define ISP_TOP_FED_CTRL_SNR1_EN_MASK			BIT(9)
#define ISP_TOP_FED_CTRL_SNR1_DIS			(0 << 9)
#define ISP_TOP_FED_CTRL_SNR1_EN			BIT(9)
#define ISP_TOP_FED_CTRL_TNR0_EN_MASK			BIT(11)
#define ISP_TOP_FED_CTRL_TNR0_DIS			(0 << 11)
#define ISP_TOP_FED_CTRL_TNR0_EN			BIT(11)
#define ISP_TOP_FED_CTRL_CUBIC_CS_EN_MASK		BIT(12)
#define ISP_TOP_FED_CTRL_CUBIC_CS_DIS			(0 << 12)
#define ISP_TOP_FED_CTRL_CUBIC_CS_EN			BIT(12)
#define ISP_TOP_FED_CTRL_SQRT_EN_MASK			BIT(14)
#define ISP_TOP_FED_CTRL_SQRT_DIS			(0 << 14)
#define ISP_TOP_FED_CTRL_SQRT_EN			BIT(14)
#define ISP_TOP_FED_CTRL_DGAIN_EN_MASK			BIT(16)
#define ISP_TOP_FED_CTRL_DGAIN_DIS			(0 << 16)
#define ISP_TOP_FED_CTRL_DGAIN_EN			BIT(16)

#define ISP_TOP_BEO_CTRL				0x041c
#define ISP_TOP_BEO_CTRL_WB_EN_MASK			BIT(6)
#define ISP_TOP_BEO_CTRL_WB_DIS				(0 << 6)
#define ISP_TOP_BEO_CTRL_WB_EN				BIT(6)
#define ISP_TOP_BEO_CTRL_BLC_EN_MASK			BIT(7)
#define ISP_TOP_BEO_CTRL_BLC_DIS			(0 << 7)
#define ISP_TOP_BEO_CTRL_BLC_EN				BIT(7)
#define ISP_TOP_BEO_CTRL_INV_DGAIN_EN_MASK		BIT(8)
#define ISP_TOP_BEO_CTRL_INV_DGAIN_DIS			(0 << 8)
#define ISP_TOP_BEO_CTRL_INV_DGAIN_EN			BIT(8)
#define ISP_TOP_BEO_CTRL_EOTF_EN_MASK			BIT(9)
#define ISP_TOP_BEO_CTRL_EOTF_DIS			(0 << 9)
#define ISP_TOP_BEO_CTRL_EOTF_EN			BIT(9)

#define ISP_TOP_BED_CTRL				0x0420
#define ISP_TOP_BED_CTRL_YHS_STAT_EN_MASK		GENMASK(1, 0)
#define ISP_TOP_BED_CTRL_YHS_STAT_DIS			(0 << 0)
#define ISP_TOP_BED_CTRL_YHS_STAT_EN			BIT(0)
#define ISP_TOP_BED_CTRL_GRPH_STAT_EN_MASK		BIT(2)
#define ISP_TOP_BED_CTRL_GRPH_STAT_DIS			(0 << 2)
#define ISP_TOP_BED_CTRL_GRPH_STAT_EN			BIT(2)
#define ISP_TOP_BED_CTRL_FMETER_EN_MASK			BIT(3)
#define ISP_TOP_BED_CTRL_FMETER_DIS			(0 << 3)
#define ISP_TOP_BED_CTRL_FMETER_EN			BIT(3)
#define ISP_TOP_BED_CTRL_BSC_EN_MASK			BIT(10)
#define ISP_TOP_BED_CTRL_BSC_DIS			(0 << 10)
#define ISP_TOP_BED_CTRL_BSC_EN				BIT(10)
#define ISP_TOP_BED_CTRL_CNR2_EN_MASK			BIT(11)
#define ISP_TOP_BED_CTRL_CNR2_DIS			(0 << 11)
#define ISP_TOP_BED_CTRL_CNR2_EN			BIT(11)
#define ISP_TOP_BED_CTRL_CM1_EN_MASK			BIT(13)
#define ISP_TOP_BED_CTRL_CM1_DIS			(0 << 13)
#define ISP_TOP_BED_CTRL_CM1_EN				BIT(13)
#define ISP_TOP_BED_CTRL_CM0_EN_MASK			BIT(14)
#define ISP_TOP_BED_CTRL_CM0_DIS			(0 << 14)
#define ISP_TOP_BED_CTRL_CM0_EN				BIT(14)
#define ISP_TOP_BED_CTRL_PST_GAMMA_EN_MASK		BIT(16)
#define ISP_TOP_BED_CTRL_PST_GAMMA_DIS			(0 << 16)
#define ISP_TOP_BED_CTRL_PST_GAMMA_EN			BIT(16)
#define ISP_TOP_BED_CTRL_LUT3D_EN_MASK			BIT(17)
#define ISP_TOP_BED_CTRL_LUT3D_DIS			(0 << 17)
#define ISP_TOP_BED_CTRL_LUT3D_EN			BIT(17)
#define ISP_TOP_BED_CTRL_CCM_EN_MASK			BIT(18)
#define ISP_TOP_BED_CTRL_CCM_DIS			(0 << 18)
#define ISP_TOP_BED_CTRL_CCM_EN				BIT(18)
#define ISP_TOP_BED_CTRL_PST_TNR_LITE_EN_MASK		BIT(21)
#define ISP_TOP_BED_CTRL_PST_TNR_LITE_DIS		(0 << 21)
#define ISP_TOP_BED_CTRL_PST_TNR_LITE_EN		BIT(21)
#define ISP_TOP_BED_CTRL_AMCM_EN_MASK			BIT(25)
#define ISP_TOP_BED_CTRL_AMCM_DIS			(0 << 25)
#define ISP_TOP_BED_CTRL_AMCM_EN			BIT(25)

#define ISP_TOP_3A_STAT_CRTL				0x0424
#define ISP_TOP_3A_STAT_CRTL_AE_STAT_EN_MASK		BIT(0)
#define ISP_TOP_3A_STAT_CRTL_AE_STAT_DIS		(0 << 0)
#define ISP_TOP_3A_STAT_CRTL_AE_STAT_EN			BIT(0)
#define ISP_TOP_3A_STAT_CRTL_AWB_STAT_EN_MASK		BIT(1)
#define ISP_TOP_3A_STAT_CRTL_AWB_STAT_DIS		(0 << 1)
#define ISP_TOP_3A_STAT_CRTL_AWB_STAT_EN		BIT(1)
#define ISP_TOP_3A_STAT_CRTL_AF_STAT_EN_MASK		BIT(2)
#define ISP_TOP_3A_STAT_CRTL_AF_STAT_DIS		(0 << 2)
#define ISP_TOP_3A_STAT_CRTL_AF_STAT_EN			BIT(2)
#define ISP_TOP_3A_STAT_CRTL_AWB_POINT_MASK		GENMASK(6, 4)
#define ISP_TOP_3A_STAT_CRTL_AWB_POINT(x)		((x) << 4)
#define ISP_TOP_3A_STAT_CRTL_AE_POINT_MASK		GENMASK(9, 8)
#define ISP_TOP_3A_STAT_CRTL_AE_POINT(x)		((x) << 8)
#define ISP_TOP_3A_STAT_CRTL_AF_POINT_MASK		GENMASK(13, 12)
#define ISP_TOP_3A_STAT_CRTL_AF_POINT(x)		((x) << 12)

#define ISP_LSWB_BLC_OFST0				0x4028
#define ISP_LSWB_BLC_OFST0_R_OFST_MASK			GENMASK(15, 0)
#define ISP_LSWB_BLC_OFST0_R_OFST(x)			((x) << 0)
#define ISP_LSWB_BLC_OFST0_GR_OFST_MASK			GENMASK(31, 16)
#define ISP_LSWB_BLC_OFST0_GR_OFST(x)			((x) << 16)

#define ISP_LSWB_BLC_OFST1				0x402c
#define ISP_LSWB_BLC_OFST1_GB_OFST_MASK			GENMASK(15, 0)
#define ISP_LSWB_BLC_OFST1_GB_OFST(x)			((x) << 0)
#define ISP_LSWB_BLC_OFST1_B_OFST_MASK			GENMASK(31, 16)
#define ISP_LSWB_BLC_OFST1_B_OFST(x)			((x) << 16)

#define ISP_LSWB_BLC_PHSOFST				0x4034
#define ISP_LSWB_BLC_PHSOFST_VERT_OFST_MASK		GENMASK(1, 0)
#define ISP_LSWB_BLC_PHSOFST_VERT_OFST(x)		((x) << 0)
#define ISP_LSWB_BLC_PHSOFST_HORIZ_OFST_MASK		GENMASK(3, 2)
#define ISP_LSWB_BLC_PHSOFST_HORIZ_OFST(x)		((x) << 2)

#define ISP_LSWB_WB_GAIN0				0x4038
#define ISP_LSWB_WB_GAIN0_R_GAIN_MASK			GENMASK(11, 0)
#define ISP_LSWB_WB_GAIN0_R_GAIN(x)			((x) << 0)
#define ISP_LSWB_WB_GAIN0_GR_GAIN_MASK			GENMASK(27, 16)
#define ISP_LSWB_WB_GAIN0_GR_GAIN(x)			((x) << 16)

#define ISP_LSWB_WB_GAIN1				0x403c
#define ISP_LSWB_WB_GAIN1_GB_GAIN_MASK			GENMASK(11, 0)
#define ISP_LSWB_WB_GAIN1_GB_GAIN(x)			((x) << 0)
#define ISP_LSWB_WB_GAIN1_B_GAIN_MASK			GENMASK(27, 16)
#define ISP_LSWB_WB_GAIN1_B_GAIN(x)			((x) << 16)

#define ISP_LSWB_WB_GAIN2				0x4040
#define ISP_LSWB_WB_GAIN2_IR_GAIN_MASK			GENMASK(11, 0)
#define ISP_LSWB_WB_GAIN2_IR_GAIN(x)			((x) << 0)

#define ISP_LSWB_WB_LIMIT0				0x4044
#define ISP_LSWB_WB_LIMIT0_WB_LIMIT_R_MASK		GENMASK(15, 0)
#define ISP_LSWB_WB_LIMIT0_WB_LIMIT_R(x)		((x) << 0)
#define ISP_LSWB_WB_LIMIT0_WB_LIMIT_R_MAX		(0x8fff << 0)
#define ISP_LSWB_WB_LIMIT0_WB_LIMIT_GR_MASK		GENMASK(31, 16)
#define ISP_LSWB_WB_LIMIT0_WB_LIMIT_GR(x)		((x) << 16)
#define ISP_LSWB_WB_LIMIT0_WB_LIMIT_GR_MAX		(0x8fff << 16)

#define ISP_LSWB_WB_LIMIT1				0x4048
#define ISP_LSWB_WB_LIMIT1_WB_LIMIT_GB_MASK		GENMASK(15, 0)
#define ISP_LSWB_WB_LIMIT1_WB_LIMIT_GB(x)		((x) << 0)
#define ISP_LSWB_WB_LIMIT1_WB_LIMIT_GB_MAX		(0x8fff << 0)
#define ISP_LSWB_WB_LIMIT1_WB_LIMIT_B_MASK		GENMASK(31, 16)
#define ISP_LSWB_WB_LIMIT1_WB_LIMIT_B(x)		((x) << 16)
#define ISP_LSWB_WB_LIMIT1_WB_LIMIT_B_MAX		(0x8fff << 16)

#define ISP_LSWB_WB_PHSOFST				0x4050
#define ISP_LSWB_WB_PHSOFST_VERT_OFST_MASK		GENMASK(1, 0)
#define ISP_LSWB_WB_PHSOFST_VERT_OFST(x)		((x) << 0)
#define ISP_LSWB_WB_PHSOFST_HORIZ_OFST_MASK		GENMASK(3, 2)
#define ISP_LSWB_WB_PHSOFST_HORIZ_OFST(x)		((x) << 2)

#define ISP_LSWB_LNS_PHSOFST				0x4054
#define ISP_LSWB_LNS_PHSOFST_VERT_OFST_MASK		GENMASK(1, 0)
#define ISP_LSWB_LNS_PHSOFST_VERT_OFST(x)		((x) << 0)
#define ISP_LSWB_LNS_PHSOFST_HORIZ_OFST_MASK		GENMASK(3, 2)
#define ISP_LSWB_LNS_PHSOFST_HORIZ_OFST(x)		((x) << 2)

#define ISP_DMS_COMMON_PARAM0				0x5000
#define ISP_DMS_COMMON_PARAM0_VERT_PHS_OFST_MASK	GENMASK(1, 0)
#define ISP_DMS_COMMON_PARAM0_VERT_PHS_OFST(x)		((x) << 0)
#define ISP_DMS_COMMON_PARAM0_HORIZ_PHS_OFST_MASK	GENMASK(3, 2)
#define ISP_DMS_COMMON_PARAM0_HORIZ_PHS_OFST(x)		((x) << 2)

#define ISP_CM0_COEF00_01				0x6048
#define ISP_CM0_COEF00_01_MTX_00_MASK			GENMASK(12, 0)
#define ISP_CM0_COEF00_01_MTX_00(x)			((x) << 0)
#define ISP_CM0_COEF00_01_MTX_01_MASK			GENMASK(28, 16)
#define ISP_CM0_COEF00_01_MTX_01(x)			((x) << 16)

#define ISP_CM0_COEF02_10				0x604c
#define ISP_CM0_COEF02_10_MTX_02_MASK			GENMASK(12, 0)
#define ISP_CM0_COEF02_10_MTX_02(x)			((x) << 0)
#define ISP_CM0_COEF02_10_MTX_10_MASK			GENMASK(28, 16)
#define ISP_CM0_COEF02_10_MTX_10(x)			((x) << 16)

#define ISP_CM0_COEF11_12				0x6050
#define ISP_CM0_COEF11_12_MTX_11_MASK			GENMASK(12, 0)
#define ISP_CM0_COEF11_12_MTX_11(x)			((x) << 0)
#define ISP_CM0_COEF11_12_MTX_12_MASK			GENMASK(28, 16)
#define ISP_CM0_COEF11_12_MTX_12(x)			((x) << 16)

#define ISP_CM0_COEF20_21				0x6054
#define ISP_CM0_COEF20_21_MTX_20_MASK			GENMASK(12, 0)
#define ISP_CM0_COEF20_21_MTX_20(x)			((x) << 0)
#define ISP_CM0_COEF20_21_MTX_21_MASK			GENMASK(28, 16)
#define ISP_CM0_COEF20_21_MTX_21(x)			((x) << 16)

#define ISP_CM0_COEF22_OUP_OFST0			0x6058
#define ISP_CM0_COEF22_OUP_OFST0_MTX_22_MASK		GENMASK(12, 0)
#define ISP_CM0_COEF22_OUP_OFST0_MTX_22(x)		((x) << 0)

#define ISP_CCM_MTX_00_01				0x6098
#define ISP_CCM_MTX_00_01_MTX_00_MASK			GENMASK(12, 0)
#define ISP_CCM_MTX_00_01_MTX_00(x)			((x) << 0)
#define ISP_CCM_MTX_00_01_MTX_01_MASK			GENMASK(28, 16)
#define ISP_CCM_MTX_00_01_MTX_01(x)			((x) << 16)

#define ISP_CCM_MTX_02_03				0x609c
#define ISP_CCM_MTX_02_03_MTX_02_MASK			GENMASK(12, 0)
#define ISP_CCM_MTX_02_03_MTX_02(x)			((x) << 0)

#define ISP_CCM_MTX_10_11				0x60A0
#define ISP_CCM_MTX_10_11_MTX_10_MASK			GENMASK(12, 0)
#define ISP_CCM_MTX_10_11_MTX_10(x)			((x) << 0)
#define ISP_CCM_MTX_10_11_MTX_11_MASK			GENMASK(28, 16)
#define ISP_CCM_MTX_10_11_MTX_11(x)			((x) << 16)

#define ISP_CCM_MTX_12_13				0x60A4
#define ISP_CCM_MTX_12_13_MTX_12_MASK			GENMASK(12, 0)
#define ISP_CCM_MTX_12_13_MTX_12(x)			((x) << 0)

#define ISP_CCM_MTX_20_21				0x60A8
#define ISP_CCM_MTX_20_21_MTX_20_MASK			GENMASK(12, 0)
#define ISP_CCM_MTX_20_21_MTX_20(x)			((x) << 0)
#define ISP_CCM_MTX_20_21_MTX_21_MASK			GENMASK(28, 16)
#define ISP_CCM_MTX_20_21_MTX_21(x)			((x) << 16)

#define ISP_CCM_MTX_22_23_RS				0x60Ac
#define ISP_CCM_MTX_22_23_RS_MTX_22_MASK		GENMASK(12, 0)
#define ISP_CCM_MTX_22_23_RS_MTX_22(x)			((x) << 0)

#define ISP_PST_GAMMA_LUT_ADDR				0x60cc
#define ISP_PST_GAMMA_LUT_ADDR_IDX_ADDR(x)		((x) << 7)

#define ISP_PST_GAMMA_LUT_DATA				0x60d0
#define ISP_PST_GM_LUT_DATA0(x)		(((x) & GENMASK(15, 0)) << 0)
#define ISP_PST_GM_LUT_DATA1(x)		(((x) & GENMASK(15, 0)) << 16)

#define DISP0_TOP_TOP_CTRL				0x8000
#define DISP0_TOP_TOP_CTRL_CROP2_EN_MASK		BIT(5)
#define DISP0_TOP_TOP_CTRL_CROP2_EN			BIT(5)
#define DISP0_TOP_TOP_CTRL_CROP2_DIS			(0 << 5)

#define DISP0_TOP_CRP2_START				0x8004
#define DISP0_TOP_CRP2_START_V_START_MASK		GENMASK(15, 0)
#define DISP0_TOP_CRP2_START_V_START(x)			((x) << 0)
#define DISP0_TOP_CRP2_START_H_START_MASK		GENMASK(31, 16)
#define DISP0_TOP_CRP2_START_H_START(x)			((x) << 16)

#define DISP0_TOP_CRP2_SIZE				0x8008
#define DISP0_TOP_CRP2_SIZE_V_SIZE_MASK			GENMASK(15, 0)
#define DISP0_TOP_CRP2_SIZE_V_SIZE(x)			((x) << 0)
#define DISP0_TOP_CRP2_SIZE_H_SIZE_MASK			GENMASK(31, 16)
#define DISP0_TOP_CRP2_SIZE_H_SIZE(x)			((x) << 16)

#define DISP0_TOP_OUT_SIZE				0x800c
#define DISP0_TOP_OUT_SIZE_SCL_OUT_HEIGHT_MASK		GENMASK(12, 0)
#define DISP0_TOP_OUT_SIZE_SCL_OUT_HEIGHT(x)		((x) << 0)
#define DISP0_TOP_OUT_SIZE_SCL_OUT_WIDTH_MASK		GENMASK(28, 16)
#define DISP0_TOP_OUT_SIZE_SCL_OUT_WIDTH(x)		((x) << 16)

#define ISP_DISP0_TOP_IN_SIZE				0x804c
#define ISP_DISP0_TOP_IN_SIZE_VSIZE_MASK		GENMASK(12, 0)
#define ISP_DISP0_TOP_IN_SIZE_VSIZE(x)			((x) << 0)
#define ISP_DISP0_TOP_IN_SIZE_HSIZE_MASK		GENMASK(28, 16)
#define ISP_DISP0_TOP_IN_SIZE_HSIZE(x)			((x) << 16)

#define DISP0_PPS_SCALE_EN				0x8200
#define DISP0_PPS_SCALE_EN_VSC_TAP_NUM_MASK		GENMASK(3, 0)
#define DISP0_PPS_SCALE_EN_VSC_TAP_NUM(x)		((x) << 0)
#define DISP0_PPS_SCALE_EN_HSC_TAP_NUM_MASK		GENMASK(7, 4)
#define DISP0_PPS_SCALE_EN_HSC_TAP_NUM(x)		((x) << 4)
#define DISP0_PPS_SCALE_EN_PREVSC_FLT_NUM_MASK		GENMASK(11, 8)
#define DISP0_PPS_SCALE_EN_PREVSC_FLT_NUM(x)		((x) << 8)
#define DISP0_PPS_SCALE_EN_PREHSC_FLT_NUM_MASK		GENMASK(15, 12)
#define DISP0_PPS_SCALE_EN_PREHSC_FLT_NUM(x)		((x) << 12)
#define DISP0_PPS_SCALE_EN_PREVSC_RATE_MASK		GENMASK(17, 16)
#define DISP0_PPS_SCALE_EN_PREVSC_RATE(x)		((x) << 16)
#define DISP0_PPS_SCALE_EN_PREHSC_RATE_MASK		GENMASK(19, 18)
#define DISP0_PPS_SCALE_EN_PREHSC_RATE(x)		((x) << 18)
#define DISP0_PPS_SCALE_EN_HSC_EN_MASK			BIT(20)
#define DISP0_PPS_SCALE_EN_HSC_EN(x)			((x) << 20)
#define DISP0_PPS_SCALE_EN_HSC_DIS			(0 << 20)
#define DISP0_PPS_SCALE_EN_VSC_EN_MASK			BIT(21)
#define DISP0_PPS_SCALE_EN_VSC_EN(x)			((x) << 21)
#define DISP0_PPS_SCALE_EN_VSC_DIS			(0 << 21)
#define DISP0_PPS_SCALE_EN_PREVSC_EN_MASK		BIT(22)
#define DISP0_PPS_SCALE_EN_PREVSC_EN(x)			((x) << 22)
#define DISP0_PPS_SCALE_EN_PREVSC_DIS			(0 << 22)
#define DISP0_PPS_SCALE_EN_PREHSC_EN_MASK		BIT(23)
#define DISP0_PPS_SCALE_EN_PREHSC_EN(x)			((x) << 23)
#define DISP0_PPS_SCALE_EN_PREHSC_DIS			(0 << 23)
#define DISP0_PPS_SCALE_EN_HSC_NOR_RS_BITS_MASK		GENMASK(27, 24)
#define DISP0_PPS_SCALE_EN_HSC_NOR_RS_BITS(x)		((x) << 24)
#define DISP0_PPS_SCALE_EN_VSC_NOR_RS_BITS_MASK		GENMASK(31, 28)
#define DISP0_PPS_SCALE_EN_VSC_NOR_RS_BITS(x)		((x) << 28)

#define DISP0_PPS_VSC_START_PHASE_STEP			0x8224
#define DISP0_PPS_VSC_START_PHASE_STEP_VERT_FRAC_MASK	GENMASK(23, 0)
#define DISP0_PPS_VSC_START_PHASE_STEP_VERT_FRAC(x)	((x) << 0)
#define DISP0_PPS_VSC_START_PHASE_STEP_VERT_INTE_MASK	GENMASK(27, 24)
#define DISP0_PPS_VSC_START_PHASE_STEP_VERT_INTE(x)	((x) << 24)

#define DISP0_PPS_HSC_START_PHASE_STEP			0x8230
#define DISP0_PPS_HSC_START_PHASE_STEP_HORIZ_FRAC_MASK	GENMASK(23, 0)
#define DISP0_PPS_HSC_START_PHASE_STEP_HORIZ_FRAC(x)	((x) << 0)
#define DISP0_PPS_HSC_START_PHASE_STEP_HORIZ_INTE_MASK	GENMASK(27, 24)
#define DISP0_PPS_HSC_START_PHASE_STEP_HORIZ_INTE(x)	((x) << 24)

#define DISP0_PPS_444TO422				0x823c
#define DISP0_PPS_444TO422_EN_MASK			BIT(0)
#define DISP0_PPS_444TO422_EN(x)			((x) << 0)

#define ISP_SCALE0_COEF_IDX_LUMA			0x8240
#define ISP_SCALE0_COEF_IDX_LUMA_COEF_S11_MODE_MASK	BIT(9)
#define ISP_SCALE0_COEF_IDX_LUMA_COEF_S11_MODE_EN	BIT(9)
#define ISP_SCALE0_COEF_IDX_LUMA_COEF_S11_MODE_DIS	(0 << 9)
#define ISP_SCALE0_COEF_IDX_LUMA_CTYPE_MASK		GENMASK(12, 10)
#define ISP_SCALE0_COEF_IDX_LUMA_CTYPE(x)		((x) << 10)

#define ISP_SCALE0_COEF_LUMA				0x8244
#define ISP_SCALE0_COEF_LUMA_DATA1(x)		(((x) & GENMASK(10, 0)) << 0)
#define ISP_SCALE0_COEF_LUMA_DATA0(x)		(((x) & GENMASK(10, 0)) << 16)

#define ISP_SCALE0_COEF_IDX_CHRO			0x8248
#define ISP_SCALE0_COEF_IDX_CHRO_COEF_S11_MODE_MASK	BIT(9)
#define ISP_SCALE0_COEF_IDX_CHRO_COEF_S11_MODE_EN	BIT(9)
#define ISP_SCALE0_COEF_IDX_CHRO_COEF_S11_MODE_DIS	(0 << 9)
#define ISP_SCALE0_COEF_IDX_CHRO_CTYPE_MASK		GENMASK(12, 10)
#define ISP_SCALE0_COEF_IDX_CHRO_CTYPE(x)		((x) << 10)

#define ISP_SCALE0_COEF_CHRO				0x824c
#define ISP_SCALE0_COEF_CHRO_DATA1(x)		(((x) & GENMASK(10, 0)) << 0)
#define ISP_SCALE0_COEF_CHRO_DATA0(x)		(((x) & GENMASK(10, 0)) << 16)

#define ISP_AF_CTRL					0xa044
#define ISP_AF_CTRL_VERT_OFST_MASK			GENMASK(15, 14)
#define ISP_AF_CTRL_VERT_OFST(x)			((x) << 14)
#define ISP_AF_CTRL_HORIZ_OFST_MASK			GENMASK(17, 16)
#define ISP_AF_CTRL_HORIZ_OFST(x)			((x) << 16)

#define ISP_AF_HV_SIZE					0xa04c
#define ISP_AF_HV_SIZE_GLB_WIN_YSIZE_MASK		GENMASK(15, 0)
#define ISP_AF_HV_SIZE_GLB_WIN_YSIZE(x)			((x) << 0)
#define ISP_AF_HV_SIZE_GLB_WIN_XSIZE_MASK		GENMASK(31, 16)
#define ISP_AF_HV_SIZE_GLB_WIN_XSIZE(x)			((x) << 16)

#define ISP_AF_HV_BLKNUM				0xa050
#define ISP_AF_HV_BLKNUM_V_NUM_MASK			GENMASK(5, 0)
#define ISP_AF_HV_BLKNUM_V_NUM(x)			((x) << 0)
#define ISP_AF_HV_BLKNUM_H_NUM_MASK			GENMASK(21, 16)
#define ISP_AF_HV_BLKNUM_H_NUM(x)			((x) << 16)

#define ISP_AF_EN_CTRL					0xa054
#define ISP_AF_EN_CTRL_STAT_SEL_MASK			BIT(21)
#define ISP_AF_EN_CTRL_STAT_SEL_OLD			(0 << 21)
#define ISP_AF_EN_CTRL_STAT_SEL_NEW			BIT(21)

#define ISP_AF_IDX_ADDR					0xa1c0
#define ISP_AF_IDX_DATA					0xa1c4
#define ISP_AF_IDX_DATA_VIDX_DATA(x)		(((x) & GENMASK(15, 0)) << 0)
#define ISP_AF_IDX_DATA_HIDX_DATA(x)		(((x) & GENMASK(15, 0)) << 16)

#define ISP_AE_CTRL					0xa448
#define ISP_AE_CTRL_INPUT_2LINE_MASK			BIT(7)
#define ISP_AE_CTRL_INPUT_2LINE_EN			BIT(7)
#define ISP_AE_CTRL_INPUT_2LINE_DIS			(0 << 7)
#define ISP_AE_CTRL_LUMA_MODE_MASK			GENMASK(9, 8)
#define ISP_AE_CTRL_LUMA_MODE_CUR			(0 << 8)
#define ISP_AE_CTRL_LUMA_MODE_MAX			BIT(8)
#define ISP_AE_CTRL_LUMA_MODE_FILTER			(2 << 8)
#define ISP_AE_CTRL_VERT_OFST_MASK			GENMASK(25, 24)
#define ISP_AE_CTRL_VERT_OFST(x)			((x) << 24)
#define ISP_AE_CTRL_HORIZ_OFST_MASK			GENMASK(27, 26)
#define ISP_AE_CTRL_HORIZ_OFST(x)			((x) << 26)

#define ISP_AE_HV_SIZE					0xa464
#define ISP_AE_HV_SIZE_VERT_SIZE_MASK			GENMASK(15, 0)
#define ISP_AE_HV_SIZE_VERT_SIZE(x)			((x) << 0)
#define ISP_AE_HV_SIZE_HORIZ_SIZE_MASK			GENMASK(31, 16)
#define ISP_AE_HV_SIZE_HORIZ_SIZE(x)			((x) << 16)

#define ISP_AE_HV_BLKNUM				0xa468
#define ISP_AE_HV_BLKNUM_V_NUM_MASK			GENMASK(6, 0)
#define ISP_AE_HV_BLKNUM_V_NUM(x)			((x) << 0)
#define ISP_AE_HV_BLKNUM_H_NUM_MASK			GENMASK(22, 16)
#define ISP_AE_HV_BLKNUM_H_NUM(x)			((x) << 16)

#define ISP_AE_IDX_ADDR					0xa600
#define ISP_AE_IDX_DATA					0xa604
#define ISP_AE_IDX_DATA_VIDX_DATA(x)		(((x) & GENMASK(15, 0)) << 0)
#define ISP_AE_IDX_DATA_HIDX_DATA(x)		(((x) & GENMASK(15, 0)) << 16)

#define ISP_AE_BLK_WT_ADDR				0xa608
#define ISP_AE_BLK_WT_DATA				0xa60c
#define ISP_AE_BLK_WT_DATA_WT(i, x)	(((x) & GENMASK(3, 0)) << ((i) * 4))

#define ISP_AWB_CTRL					0xa834
#define ISP_AWB_CTRL_VERT_OFST_MASK			GENMASK(1, 0)
#define ISP_AWB_CTRL_VERT_OFST(x)			((x) << 0)
#define ISP_AWB_CTRL_HORIZ_OFST_MASK			GENMASK(3, 2)
#define ISP_AWB_CTRL_HORIZ_OFST(x)			((x) << 2)

#define ISP_AWB_HV_SIZE					0xa83c
#define ISP_AWB_HV_SIZE_VERT_SIZE_MASK			GENMASK(15, 0)
#define ISP_AWB_HV_SIZE_VERT_SIZE(x)			((x) << 0)
#define ISP_AWB_HV_SIZE_HORIZ_SIZE_MASK			GENMASK(31, 16)
#define ISP_AWB_HV_SIZE_HORIZ_SIZE(x)			((x) << 16)

#define ISP_AWB_HV_BLKNUM				0xa840
#define ISP_AWB_HV_BLKNUM_V_NUM_MASK			GENMASK(5, 0)
#define ISP_AWB_HV_BLKNUM_V_NUM(x)			((x) << 0)
#define ISP_AWB_HV_BLKNUM_H_NUM_MASK			GENMASK(21, 16)
#define ISP_AWB_HV_BLKNUM_H_NUM(x)			((x) << 16)

#define ISP_AWB_STAT_RG					0xa848
#define ISP_AWB_STAT_RG_MIN_VALUE_MASK			GENMASK(11, 0)
#define ISP_AWB_STAT_RG_MIN_VALUE(x)			((x) << 0)
#define ISP_AWB_STAT_RG_MAX_VALUE_MASK			GENMASK(27, 16)
#define ISP_AWB_STAT_RG_MAX_VALUE(x)			((x) << 16)

#define ISP_AWB_STAT_BG					0xa84c
#define ISP_AWB_STAT_BG_MIN_VALUE_MASK			GENMASK(11, 0)
#define ISP_AWB_STAT_BG_MIN_VALUE(x)			((x) << 0)
#define ISP_AWB_STAT_BG_MAX_VALUE_MASK			GENMASK(27, 16)
#define ISP_AWB_STAT_BG_MAX_VALUE(x)			((x) << 16)

#define ISP_AWB_STAT_RG_HL				0xa850
#define ISP_AWB_STAT_RG_HL_LOW_VALUE_MASK		GENMASK(11, 0)
#define ISP_AWB_STAT_RG_HL_LOW_VALUE(x)			((x) << 0)
#define ISP_AWB_STAT_RG_HL_HIGH_VALUE_MASK		GENMASK(27, 16)
#define ISP_AWB_STAT_RG_HL_HIGH_VALUE(x)		((x) << 16)

#define ISP_AWB_STAT_BG_HL				0xa854
#define ISP_AWB_STAT_BG_HL_LOW_VALUE_MASK		GENMASK(11, 0)
#define ISP_AWB_STAT_BG_HL_LOW_VALUE(x)			((x) << 0)
#define ISP_AWB_STAT_BG_HL_HIGH_VALUE_MASK		GENMASK(27, 16)
#define ISP_AWB_STAT_BG_HL_HIGH_VALUE(x)		((x) << 16)

#define ISP_AWB_STAT_CTRL2				0xa858
#define ISP_AWB_STAT_CTRL2_SATUR_CTRL_MASK		BIT(0)
#define ISP_AWB_STAT_CTRL2_SATUR_CTRL(x)		((x) << 0)

#define ISP_AWB_IDX_ADDR				0xaa00
#define ISP_AWB_IDX_DATA				0xaa04
#define ISP_AWB_IDX_DATA_VIDX_DATA(x)		(((x) & GENMASK(15, 0)) << 0)
#define ISP_AWB_IDX_DATA_HIDX_DATA(x)		(((x) & GENMASK(15, 0)) << 16)

#define ISP_AWB_BLK_WT_ADDR				0xaa08
#define ISP_AWB_BLK_WT_DATA				0xaa0c
#define ISP_AWB_BLK_WT_DATA_WT(i, x)	(((x) & GENMASK(3, 0)) << ((i) * 4))

#define ISP_WRMIFX3_0_CH0_CTRL0				0xc400
#define ISP_WRMIFX3_0_CH0_CTRL0_STRIDE_MASK		GENMASK(28, 16)
#define ISP_WRMIFX3_0_CH0_CTRL0_STRIDE(x)		((x) << 16)

#define ISP_WRMIFX3_0_CH0_CTRL1				0xc404
#define ISP_WRMIFX3_0_CH0_CTRL1_PIX_BITS_MODE_MASK	GENMASK(30, 27)
#define ISP_WRMIFX3_0_CH0_CTRL1_PIX_BITS_8BITS		BIT(27)
#define ISP_WRMIFX3_0_CH0_CTRL1_PIX_BITS_16BITS		(2 << 27)

#define ISP_WRMIFX3_0_CH1_CTRL0				0xc408
#define ISP_WRMIFX3_0_CH1_CTRL0_STRIDE_MASK		GENMASK(28, 16)
#define ISP_WRMIFX3_0_CH1_CTRL0_STRIDE(x)		((x) << 16)

#define ISP_WRMIFX3_0_CH1_CTRL1				0xc40c
#define ISP_WRMIFX3_0_CH1_CTRL1_PIX_BITS_MODE_MASK	GENMASK(30, 27)
#define ISP_WRMIFX3_0_CH1_CTRL1_PIX_BITS_8BITS		BIT(27)
#define ISP_WRMIFX3_0_CH1_CTRL1_PIX_BITS_16BITS		(2 << 27)
#define ISP_WRMIFX3_0_CH1_CTRL1_PIX_BITS_32BITS		(3 << 27)

#define ISP_WRMIFX3_0_WIN_LUMA_H			0xc420
#define ISP_WRMIFX3_0_WIN_LUMA_H_LUMA_HEND_MASK		GENMASK(28, 16)
#define ISP_WRMIFX3_0_WIN_LUMA_H_LUMA_HEND(x)		(((x) - 1) << 16)

#define ISP_WRMIFX3_0_WIN_LUMA_V			0xc424
#define ISP_WRMIFX3_0_WIN_LUMA_V_LUMA_VEND_MASK		GENMASK(28, 16)
#define ISP_WRMIFX3_0_WIN_LUMA_V_LUMA_VEND(x)		(((x) - 1) << 16)

#define ISP_WRMIFX3_0_WIN_CHROM_H			0xc428
#define ISP_WRMIFX3_0_WIN_CHROM_H_CHROM_HEND_MASK	GENMASK(28, 16)
#define ISP_WRMIFX3_0_WIN_CHROM_H_CHROM_HEND(x)		(((x) - 1) << 16)

#define ISP_WRMIFX3_0_WIN_CHROM_V			0xc42c
#define ISP_WRMIFX3_0_WIN_CHROM_V_CHROM_VEND_MASK	GENMASK(28, 16)
#define ISP_WRMIFX3_0_WIN_CHROM_V_CHROM_VEND(x)		(((x) - 1) << 16)

#define ISP_WRMIFX3_0_CH0_BADDR				0xc440
#define ISP_WRMIFX3_0_CH0_BASE_ADDR(x)			((x) >> 4)

#define ISP_WRMIFX3_0_CH1_BADDR				0xc444
#define ISP_WRMIFX3_0_CH1_BASE_ADDR(x)			((x) >> 4)

#define ISP_WRMIFX3_0_FMT_SIZE				0xc464
#define ISP_WRMIFX3_0_FMT_SIZE_HSIZE_MASK		GENMASK(15, 0)
#define ISP_WRMIFX3_0_FMT_SIZE_HSIZE(x)			((x) << 0)
#define ISP_WRMIFX3_0_FMT_SIZE_VSIZE_MASK		GENMASK(31, 16)
#define ISP_WRMIFX3_0_FMT_SIZE_VSIZE(x)			((x) << 16)

#define ISP_WRMIFX3_0_FMT_CTRL				0xc468
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_IBITS_MASK		GENMASK(1, 0)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_IBITS_8BIT		(0 << 0)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_IBITS_10BIT		BIT(0)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_IBITS_12BIT		(2 << 0)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_IBITS_16BIT		(3 << 0)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_UV_SWAP_MASK		BIT(2)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_UV_SWAP_VU		(0 << 2)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_UV_SWAP_UV		BIT(2)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_PLANE_MASK		GENMASK(5, 4)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_PLANE_X1		(0 << 4)
#define ISP_WRMIFX3_0_FMT_CTRL_MTX_PLANE_X2		BIT(4)
#define ISP_WRMIFX3_0_FMT_CTRL_MODE_OUT_MASK		GENMASK(18, 16)
#define ISP_WRMIFX3_0_FMT_CTRL_MODE_OUT_YUV422		BIT(16)
#define ISP_WRMIFX3_0_FMT_CTRL_MODE_OUT_YUV420		(2 << 16)
#define ISP_WRMIFX3_0_FMT_CTRL_MODE_OUT_Y_ONLY		(3 << 16)
#define ISP_WRMIFX3_0_FMT_CTRL_MODE_OUT_RAW		(4 << 16)

#define VIU_DMAWR_BADDR0				0xc840
#define VIU_DMAWR_BADDR0_AF_STATS_BASE_ADDR_MASK	GENMASK(27, 0)
#define VIU_DMAWR_BADDR0_AF_STATS_BASE_ADDR(x)		((x) >> 4)

#define VIU_DMAWR_BADDR1				0xc844
#define VIU_DMAWR_BADDR1_AWB_STATS_BASE_ADDR_MASK	GENMASK(27, 0)
#define VIU_DMAWR_BADDR1_AWB_STATS_BASE_ADDR(x)		((x) >> 4)

#define VIU_DMAWR_BADDR2				0xc848
#define VIU_DMAWR_BADDR2_AE_STATS_BASE_ADDR_MASK	GENMASK(27, 0)
#define VIU_DMAWR_BADDR2_AE_STATS_BASE_ADDR(x)		((x) >> 4)

#define VIU_DMAWR_SIZE0					0xc854
#define VIU_DMAWR_SIZE0_AF_STATS_SIZE_MASK		GENMASK(15, 0)
#define VIU_DMAWR_SIZE0_AF_STATS_SIZE(x)		((x) << 0)
#define VIU_DMAWR_SIZE0_AWB_STATS_SIZE_MASK		GENMASK(31, 16)
#define VIU_DMAWR_SIZE0_AWB_STATS_SIZE(x)		((x) << 16)

#define VIU_DMAWR_SIZE1					0xc858
#define VIU_DMAWR_SIZE1_AE_STATS_SIZE_MASK		GENMASK(15, 0)
#define VIU_DMAWR_SIZE1_AE_STATS_SIZE(x)		((x) << 0)

#endif
