//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridcontainerservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridcontainerservice/armhybridcontainerservice"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/preview/2023-11-15-preview/examples/GetProvisionedClusterInstance.json
func ExampleProvisionedClusterInstancesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProvisionedClusterInstancesClient().Get(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProvisionedClusters = armhybridcontainerservice.ProvisionedClusters{
	// 	Name: to.Ptr("test-hybridakscluster"),
	// 	Type: to.Ptr("Microsoft.HybridContainerService/provisionedClusterInstances"),
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default"),
	// 	ExtendedLocation: &armhybridcontainerservice.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
	// 		Type: to.Ptr(armhybridcontainerservice.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armhybridcontainerservice.ProvisionedClusterProperties{
	// 		AgentPoolProfiles: []*armhybridcontainerservice.NamedAgentPoolProfile{
	// 			{
	// 				Name: to.Ptr("default-nodepool-1"),
	// 				OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
	// 				Count: to.Ptr[int32](1),
	// 				VMSize: to.Ptr("Standard_A4_v2"),
	// 		}},
	// 		CloudProviderProfile: &armhybridcontainerservice.CloudProviderProfile{
	// 			InfraNetworkProfile: &armhybridcontainerservice.CloudProviderProfileInfraNetworkProfile{
	// 				VnetSubnetIDs: []*string{
	// 					to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.AzureStackHCI/logicalNetworks/test-vnet-static")},
	// 				},
	// 			},
	// 			ControlPlane: &armhybridcontainerservice.ControlPlaneProfile{
	// 				LinuxProfile: &armhybridcontainerservice.LinuxProfileProperties{
	// 					SSH: &armhybridcontainerservice.LinuxProfilePropertiesSSH{
	// 						PublicKeys: []*armhybridcontainerservice.LinuxProfilePropertiesSSHPublicKeysItem{
	// 							{
	// 								KeyData: to.Ptr("ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......"),
	// 						}},
	// 					},
	// 				},
	// 				OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
	// 				Count: to.Ptr[int32](1),
	// 				VMSize: to.Ptr("Standard_A4_v2"),
	// 			},
	// 			KubernetesVersion: to.Ptr("v1.20.5"),
	// 			LicenseProfile: &armhybridcontainerservice.ProvisionedClusterLicenseProfile{
	// 				AzureHybridBenefit: to.Ptr(armhybridcontainerservice.AzureHybridBenefitNotApplicable),
	// 			},
	// 			LinuxProfile: &armhybridcontainerservice.LinuxProfileProperties{
	// 				SSH: &armhybridcontainerservice.LinuxProfilePropertiesSSH{
	// 					PublicKeys: []*armhybridcontainerservice.LinuxProfilePropertiesSSHPublicKeysItem{
	// 						{
	// 							KeyData: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY......."),
	// 					}},
	// 				},
	// 			},
	// 			NetworkProfile: &armhybridcontainerservice.NetworkProfile{
	// 				NetworkPolicy: to.Ptr(armhybridcontainerservice.NetworkPolicyCalico),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 			},
	// 			ProvisioningState: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/preview/2023-11-15-preview/examples/PutProvisionedClusterInstance.json
func ExampleProvisionedClusterInstancesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProvisionedClusterInstancesClient().BeginCreateOrUpdate(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster", armhybridcontainerservice.ProvisionedClusters{
		ExtendedLocation: &armhybridcontainerservice.ExtendedLocation{
			Name: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
			Type: to.Ptr(armhybridcontainerservice.ExtendedLocationTypesCustomLocation),
		},
		Properties: &armhybridcontainerservice.ProvisionedClusterProperties{
			AgentPoolProfiles: []*armhybridcontainerservice.NamedAgentPoolProfile{
				{
					Name:   to.Ptr("default-nodepool-1"),
					OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
					Count:  to.Ptr[int32](1),
					VMSize: to.Ptr("Standard_A4_v2"),
				}},
			CloudProviderProfile: &armhybridcontainerservice.CloudProviderProfile{
				InfraNetworkProfile: &armhybridcontainerservice.CloudProviderProfileInfraNetworkProfile{
					VnetSubnetIDs: []*string{
						to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.AzureStackHCI/logicalNetworks/test-vnet-static")},
				},
			},
			ControlPlane: &armhybridcontainerservice.ControlPlaneProfile{
				LinuxProfile: &armhybridcontainerservice.LinuxProfileProperties{
					SSH: &armhybridcontainerservice.LinuxProfilePropertiesSSH{
						PublicKeys: []*armhybridcontainerservice.LinuxProfilePropertiesSSHPublicKeysItem{
							{
								KeyData: to.Ptr("ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......"),
							}},
					},
				},
				OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
				Count:  to.Ptr[int32](1),
				VMSize: to.Ptr("Standard_A4_v2"),
			},
			KubernetesVersion: to.Ptr("v1.20.5"),
			LicenseProfile: &armhybridcontainerservice.ProvisionedClusterLicenseProfile{
				AzureHybridBenefit: to.Ptr(armhybridcontainerservice.AzureHybridBenefitNotApplicable),
			},
			LinuxProfile: &armhybridcontainerservice.LinuxProfileProperties{
				SSH: &armhybridcontainerservice.LinuxProfilePropertiesSSH{
					PublicKeys: []*armhybridcontainerservice.LinuxProfilePropertiesSSHPublicKeysItem{
						{
							KeyData: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY......."),
						}},
				},
			},
			NetworkProfile: &armhybridcontainerservice.NetworkProfile{
				NetworkPolicy: to.Ptr(armhybridcontainerservice.NetworkPolicyCalico),
				PodCidr:       to.Ptr("10.244.0.0/16"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProvisionedClusters = armhybridcontainerservice.ProvisionedClusters{
	// 	Name: to.Ptr("test-hybridakscluster"),
	// 	Type: to.Ptr("Microsoft.HybridContainerService/provisionedClusterInstances"),
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default"),
	// 	ExtendedLocation: &armhybridcontainerservice.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
	// 		Type: to.Ptr(armhybridcontainerservice.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armhybridcontainerservice.ProvisionedClusterProperties{
	// 		AgentPoolProfiles: []*armhybridcontainerservice.NamedAgentPoolProfile{
	// 			{
	// 				Name: to.Ptr("default-nodepool-1"),
	// 				OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
	// 				Count: to.Ptr[int32](1),
	// 				VMSize: to.Ptr("Standard_A4_v2"),
	// 		}},
	// 		CloudProviderProfile: &armhybridcontainerservice.CloudProviderProfile{
	// 			InfraNetworkProfile: &armhybridcontainerservice.CloudProviderProfileInfraNetworkProfile{
	// 				VnetSubnetIDs: []*string{
	// 					to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.AzureStackHCI/logicalNetworks/test-vnet-static")},
	// 				},
	// 			},
	// 			ControlPlane: &armhybridcontainerservice.ControlPlaneProfile{
	// 				LinuxProfile: &armhybridcontainerservice.LinuxProfileProperties{
	// 					SSH: &armhybridcontainerservice.LinuxProfilePropertiesSSH{
	// 						PublicKeys: []*armhybridcontainerservice.LinuxProfilePropertiesSSHPublicKeysItem{
	// 							{
	// 								KeyData: to.Ptr("ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......"),
	// 						}},
	// 					},
	// 				},
	// 				OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
	// 				Count: to.Ptr[int32](1),
	// 				VMSize: to.Ptr("Standard_A4_v2"),
	// 			},
	// 			KubernetesVersion: to.Ptr("v1.20.5"),
	// 			LicenseProfile: &armhybridcontainerservice.ProvisionedClusterLicenseProfile{
	// 				AzureHybridBenefit: to.Ptr(armhybridcontainerservice.AzureHybridBenefitNotApplicable),
	// 			},
	// 			LinuxProfile: &armhybridcontainerservice.LinuxProfileProperties{
	// 				SSH: &armhybridcontainerservice.LinuxProfilePropertiesSSH{
	// 					PublicKeys: []*armhybridcontainerservice.LinuxProfilePropertiesSSHPublicKeysItem{
	// 						{
	// 							KeyData: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY......."),
	// 					}},
	// 				},
	// 			},
	// 			NetworkProfile: &armhybridcontainerservice.NetworkProfile{
	// 				NetworkPolicy: to.Ptr(armhybridcontainerservice.NetworkPolicyCalico),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 			},
	// 			ProvisioningState: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/preview/2023-11-15-preview/examples/DeleteProvisionedClusterInstance.json
func ExampleProvisionedClusterInstancesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProvisionedClusterInstancesClient().BeginDelete(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/preview/2023-11-15-preview/examples/ListProvisionedClusterInstances.json
func ExampleProvisionedClusterInstancesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProvisionedClusterInstancesClient().NewListPager("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProvisionedClustersListResult = armhybridcontainerservice.ProvisionedClustersListResult{
		// 	Value: []*armhybridcontainerservice.ProvisionedClusters{
		// 		{
		// 			Name: to.Ptr("test-hybridakscluster"),
		// 			Type: to.Ptr("Microsoft.HybridContainerService/provisionedClusterInstances"),
		// 			ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default"),
		// 			ExtendedLocation: &armhybridcontainerservice.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
		// 				Type: to.Ptr(armhybridcontainerservice.ExtendedLocationTypesCustomLocation),
		// 			},
		// 			Properties: &armhybridcontainerservice.ProvisionedClusterProperties{
		// 				AgentPoolProfiles: []*armhybridcontainerservice.NamedAgentPoolProfile{
		// 					{
		// 						Name: to.Ptr("default-nodepool-1"),
		// 						OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
		// 						Count: to.Ptr[int32](1),
		// 						VMSize: to.Ptr("Standard_A4_v2"),
		// 				}},
		// 				CloudProviderProfile: &armhybridcontainerservice.CloudProviderProfile{
		// 					InfraNetworkProfile: &armhybridcontainerservice.CloudProviderProfileInfraNetworkProfile{
		// 						VnetSubnetIDs: []*string{
		// 							to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.AzureStackHCI/logicalNetworks/test-vnet-static")},
		// 						},
		// 					},
		// 					ControlPlane: &armhybridcontainerservice.ControlPlaneProfile{
		// 						LinuxProfile: &armhybridcontainerservice.LinuxProfileProperties{
		// 							SSH: &armhybridcontainerservice.LinuxProfilePropertiesSSH{
		// 								PublicKeys: []*armhybridcontainerservice.LinuxProfilePropertiesSSHPublicKeysItem{
		// 									{
		// 										KeyData: to.Ptr("ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......"),
		// 								}},
		// 							},
		// 						},
		// 						OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
		// 						Count: to.Ptr[int32](1),
		// 						VMSize: to.Ptr("Standard_A4_v2"),
		// 					},
		// 					KubernetesVersion: to.Ptr("v1.20.5"),
		// 					LicenseProfile: &armhybridcontainerservice.ProvisionedClusterLicenseProfile{
		// 						AzureHybridBenefit: to.Ptr(armhybridcontainerservice.AzureHybridBenefitNotApplicable),
		// 					},
		// 					LinuxProfile: &armhybridcontainerservice.LinuxProfileProperties{
		// 						SSH: &armhybridcontainerservice.LinuxProfilePropertiesSSH{
		// 							PublicKeys: []*armhybridcontainerservice.LinuxProfilePropertiesSSHPublicKeysItem{
		// 								{
		// 									KeyData: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY......."),
		// 							}},
		// 						},
		// 					},
		// 					NetworkProfile: &armhybridcontainerservice.NetworkProfile{
		// 						NetworkPolicy: to.Ptr(armhybridcontainerservice.NetworkPolicyCalico),
		// 						PodCidr: to.Ptr("10.244.0.0/16"),
		// 					},
		// 					ProvisioningState: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/preview/2023-11-15-preview/examples/ProvisionedClusterInstanceGetUpgradeProfile.json
func ExampleProvisionedClusterInstancesClient_GetUpgradeProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProvisionedClusterInstancesClient().GetUpgradeProfile(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProvisionedClusterUpgradeProfile = armhybridcontainerservice.ProvisionedClusterUpgradeProfile{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.HybridContainerService/provisionedClusterInstances/upgradeprofiles"),
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default/upgradeprofiles/default"),
	// 	Properties: &armhybridcontainerservice.ProvisionedClusterUpgradeProfileProperties{
	// 		AgentPoolProfiles: []*armhybridcontainerservice.ProvisionedClusterPoolUpgradeProfile{
	// 			{
	// 				Name: to.Ptr("agent"),
	// 				KubernetesVersion: to.Ptr("1.7.7"),
	// 				OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
	// 				Upgrades: []*armhybridcontainerservice.ProvisionedClusterPoolUpgradeProfileProperties{
	// 					{
	// 						KubernetesVersion: to.Ptr("1.7.9"),
	// 					},
	// 					{
	// 						IsPreview: to.Ptr(true),
	// 						KubernetesVersion: to.Ptr("1.7.11"),
	// 				}},
	// 		}},
	// 		ControlPlaneProfile: &armhybridcontainerservice.ProvisionedClusterPoolUpgradeProfile{
	// 			Name: to.Ptr("master"),
	// 			KubernetesVersion: to.Ptr("1.7.7"),
	// 			OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
	// 			Upgrades: []*armhybridcontainerservice.ProvisionedClusterPoolUpgradeProfileProperties{
	// 				{
	// 					IsPreview: to.Ptr(true),
	// 					KubernetesVersion: to.Ptr("1.7.9"),
	// 				},
	// 				{
	// 					KubernetesVersion: to.Ptr("1.7.11"),
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/preview/2023-11-15-preview/examples/ProvisionedClusterInstanceListUserKubeconfig.json
func ExampleProvisionedClusterInstancesClient_BeginListUserKubeconfig() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProvisionedClusterInstancesClient().BeginListUserKubeconfig(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListCredentialResponse = armhybridcontainerservice.ListCredentialResponse{
	// 	Name: to.Ptr("766ea16c-53c6-421e-9b7d-a8bea47285ed*36530D233A0F410A40772AE878D8E7A0B2223081048946AD3D40DE0268480FBE"),
	// 	ID: to.Ptr("/providers/Microsoft.HybridContainerService/locations/EASTUS/operationStatuses/766ea16c-53c6-421e-9b7d-a8bea47285ed*36530D233A0F410A40772AE878D8E7A0B2223081048946AD3D40DE0268480FBE"),
	// 	Properties: &armhybridcontainerservice.ListCredentialResponseProperties{
	// 		Kubeconfigs: []*armhybridcontainerservice.CredentialResult{
	// 			{
	// 				Name: to.Ptr("credentialName1"),
	// 				Value: []byte("Y3JlZGVudGlhbFZhbHVlMQ=="),
	// 		}},
	// 	},
	// 	ResourceID: to.Ptr("/subscriptions/921d26b3-c14d-4efc-b56e-93a2439e028c/resourceGroups/rg/providers/Microsoft.HybridContainerService/provisionedClusters/cluster-pc-1-24"),
	// 	Status: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/preview/2023-11-15-preview/examples/ProvisionedClusterInstanceListAdminKubeconfig.json
func ExampleProvisionedClusterInstancesClient_BeginListAdminKubeconfig() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProvisionedClusterInstancesClient().BeginListAdminKubeconfig(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/test-hybridakscluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListCredentialResponse = armhybridcontainerservice.ListCredentialResponse{
	// 	Name: to.Ptr("766ea16c-53c6-421e-9b7d-a8bea47285ed*36530D233A0F410A40772AE878D8E7A0B2223081048946AD3D40DE0268480FBE"),
	// 	ID: to.Ptr("/providers/Microsoft.HybridContainerService/locations/EASTUS/operationStatuses/766ea16c-53c6-421e-9b7d-a8bea47285ed*36530D233A0F410A40772AE878D8E7A0B2223081048946AD3D40DE0268480FBE"),
	// 	Properties: &armhybridcontainerservice.ListCredentialResponseProperties{
	// 		Kubeconfigs: []*armhybridcontainerservice.CredentialResult{
	// 			{
	// 				Name: to.Ptr("credentialName1"),
	// 				Value: []byte("Y3JlZGVudGlhbFZhbHVlMQ=="),
	// 		}},
	// 	},
	// 	ResourceID: to.Ptr("/subscriptions/921d26b3-c14d-4efc-b56e-93a2439e028c/resourceGroups/rg/providers/Microsoft.HybridContainerService/provisionedClusters/cluster-pc-1-24"),
	// 	Status: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
	// }
}
