#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2019 BetaRays <array@dotslashplay.it>
set -o errexit

###
# Populous series:
# - Populous: Promised Lands
# - Populous 2
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250809.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID_EPISODE1='populous-1'
GAME_NAME_EPISODE1='Populous: Promised Lands'

GAME_ID_EPISODE2='populous-2'
GAME_NAME_EPISODE2='Populous 2'

## Populous: Promised Lands

ARCHIVE_BASE_EPISODE1_1_NAME='setup_populous_with_promised_lands_1.0_(28044).exe'
ARCHIVE_BASE_EPISODE1_1_MD5='c9d5e903afd9cf1974489579945288d1'
ARCHIVE_BASE_EPISODE1_1_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_1_VERSION='1.0-gog28044'
ARCHIVE_BASE_EPISODE1_1_SIZE='21067'
ARCHIVE_BASE_EPISODE1_1_URL='https://www.gog.com/game/populous'

ARCHIVE_BASE_EPISODE1_0_NAME='setup_populous_promised_lands_2.0.0.3.exe'
ARCHIVE_BASE_EPISODE1_0_MD5='4c1844f4077b46925a57abca8111f26a'
ARCHIVE_BASE_EPISODE1_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.0-gog2.0.0.3'
ARCHIVE_BASE_EPISODE1_0_SIZE='28000'

## Populous 2

ARCHIVE_BASE_EPISODE2_1_NAME='setup_populous_2_1.0_(28044).exe'
ARCHIVE_BASE_EPISODE2_1_MD5='a047f275774435f2c20b40c44b1707e0'
ARCHIVE_BASE_EPISODE2_1_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_1_SIZE='28608'
ARCHIVE_BASE_EPISODE2_1_VERSION='1.0-gog28044'
ARCHIVE_BASE_EPISODE2_1_URL='https://www.gog.com/game/populous_2'

ARCHIVE_BASE_EPISODE2_0_NAME='setup_populous2_2.0.0.2.exe'
ARCHIVE_BASE_EPISODE2_0_MD5='4f3b46cbadcd44821c212d96ef02cec5'
ARCHIVE_BASE_EPISODE2_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_0_SIZE='31000'
ARCHIVE_BASE_EPISODE2_0_VERSION='1.0-gog2.0.0.2'
ARCHIVE_BASE_EPISODE2_0_URL='https://www.gog.com/game/populous_2'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_EPISODE1_0='app'
CONTENT_PATH_DEFAULT_EPISODE2_0='app'
CONTENT_GAME_MAIN_FILES_EPISODE1='
data
populous.exe'
CONTENT_GAME_MAIN_FILES_EPISODE2='
data
sound
pop2.exe
intro.exe'
CONTENT_DOC_MAIN_FILES='
*.pdf'

USER_PERSISTENT_DIRECTORIES='
data
sound
popsave'

APP_MAIN_EXE_EPISODE1='populous.exe'
APP_MAIN_EXE_EPISODE2='pop2.exe'
APP_MAIN_ICON_EPISODE1='app/goggame-1207658963.ico'
APP_MAIN_ICON_EPISODE1_0='gfw_high.ico'
APP_MAIN_ICON_EPISODE2='app/goggame-1207658981.ico'
APP_MAIN_ICON_EPISODE2_0='gfw_high.ico'
APP_MAIN_DOSBOX_PRERUN_EPISODE2='
intro.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
